<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* Parent controller for areas of the site limited to logged-in users.
*
* @package direct-project-innovation-initiative
* @subpackage controllers
* @filesource
*/

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Restricted_controller extends CI_Controller {
	protected $permissions;
	function __construct() {	
		parent::__construct();
				
		session_set_cookie_params(0,'/'.strtolower(get_class($this)),DIRECT_DOMAIN,TRUE,TRUE);
		session_cache_limiter('none');
		session_start();
		date_default_timezone_set(ENVIRONMENT_TIMEZONE);
		
		$this->load->library(array('encrypt', 'form_validation'));
		$this->form_validation->set_error_delimiters('', '');
		$this->load->model('user_model');
		$this->load->model('rolesmodel');
		//if user is not authenticated, redirect to auth page, otherwise proceed to load controller
		if($this->session->userdata("is_loggedin") != "true") { $this->session->sess_destroy(); session_destroy(); redirect("auth"); }
		
		//prev last activity update set to current last activity so we can reset it for functions we don't want to consider "activity"
		if(strlen($this->session->userdata('app_last_activity')) > 0) { $this->session->set_userdata('prev_last_activity',$this->session->userdata('app_last_activity')); }
		//if last activity not yet set, set it to current time
		else { $this->session->set_userdata('app_last_activity',time()); }
		
        //check if it the user needs to be logged out due to inactivity
        if(abs($this->session->userdata('app_last_activity') - time()) > (SESSION_TIMEOUT_MINS*60)) { $this->session->sess_destroy(); session_destroy(); redirect("auth"); }    
        //update the last activity for the timeout
		else { $this->session->set_userdata('app_last_activity',time()); }

		//check if user has been removed since last page load
		$this->load->database();
		$user_exists = $this->db->query("SELECT user_name FROM users WHERE user_deleted_flag=0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
		//only destroy session if query successfully shows that the user no longer exists among active users
		if($user_exists) { if($user_exists->num_rows() < 1 || $user_exists->num_rows() > 1) { $this->session->sess_destroy(); session_destroy(); redirect("auth"); } }
		
		$user_timezone = $this->get_user_timezone();
		if($user_timezone) {
			date_default_timezone_set($user_timezone);
		}
		
		$ldapconfig["user"] = $this->session->userdata("username");
		$ldapconfig["pwd"] = $this->encrypt->decode($this->session->userdata("ep"));
		$this->load->library("ldap",$ldapconfig);
		
		$group_mailboxes = $this->ldap->get_group_membership('uid='.$this->session->userdata('username').','.LDAP_ACCOUNTS_DN);
		$this->session->set_userdata('group_mailboxes',$group_mailboxes);
		
		$this->permissions = $this->rolesmodel->user_permissions($this->user_model->logged_in_user('dn'));
	}	
	public function has_permission($permission){
		if($this->user_model->is_admin()){
			return true;
		}
		return in_array($permission,$this->permissions);
	}
	public function verify_permission($permission){
		if($this->user_model->is_admin()){
			return;
		}
		if(!in_array($permission,$this->permissions)){
			show_404();
		}
	}
	protected function get_user_id($username) {
		$get_id = $this->db->query('SELECT user_id FROM users WHERE user_name=' . $this->db->escape($username));
		if($get_id && $get_id->num_rows() == 1) {
			$get_id_row = $get_id->row_array();
			return $get_id_row['user_id'];
		}
		return FALSE;
	}	
	
	protected function get_user_timezone() {
		$this->load->database();
		$this->load->library('locale');
		$locale_query = $this->db->query('SELECT user_locale FROM users WHERE user_name='.$this->db->escape($this->session->userdata('username')));
		if($locale_query) {
			$locale = $locale_query->row_array();
			$locale = unserialize($locale['user_locale']);
			if($locale) {
				return $this->locale->get_timezone_from_id($locale['timezone']);
			}
		}
		return FALSE;
	}
	
}
